minetest.register_on_joinplayer(function(player)
    local name = player:get_player_name()
    local meta = player:get_meta()
    local idx = player:hud_add({
         hud_elem_type = "text",
         position      = {x = 0.5, y = 0.5},
         offset        = {x = 0,   y = 0},
         text          = "Hello world!",
         alignment     = {x = 0, y = 0},  -- center aligned
         scale         = {x = 100, y = 100}, -- covered later
    })

    --The hud_add function returns an element ID - this can be used later to modify or remove a HUD element.
    --Parameters

    --The element’s type is given using the hud_elem_type property in the definition table. The meaning of other properties varies based on this type.

    --scale is the maximum bounds of text; text outside these bounds is cropped, e.g.: {x=100, y=100}.

    --number is the text’s colour, and is in hexadecimal form, e.g.: 0xFF0000.
    --Our Example

    --Let’s go ahead and place all the text in our score panel:

    -- Get the dig and place count from storage, or default to 0
    local meta        = player:get_meta()
    local digs_text   = "Digs: " .. meta:get_int("score:digs")
    local places_text = "Places: " .. meta:get_int("score:places")

    player:hud_add({
        hud_elem_type = "text",
        position  = {x = 1, y = 0.5},
        offset    = {x = -120, y = -25},
        text      = "Stats",
        alignment = 0,
        scale     = { x = 100, y = 30},
        number    = 0xFFFFFF,
    })

    player:hud_add({
        hud_elem_type = "text",
        position  = {x = 1, y = 0.5},
        offset    = {x = -180, y = 0},
        text      = digs_text,
        alignment = -1,
        scale     = { x = 50, y = 10},
        number    = 0xFFFFFF,
    })

    player:hud_add({
        hud_elem_type = "text",
        position  = {x = 1, y = 0.5},
        offset    = {x = -70, y = 0},
        text      = places_text,
        alignment = -1,
        scale     = { x = 50, y = 10},
        number    = 0xFFFFFF,
    })

    --This results in the following:
    --screenshot of the HUD we're aiming for
    --Image Elements

    --Image elements are created in a very similar way to text elements:

    player:hud_add({
        hud_elem_type = "image",
        position  = {x = 1, y = 0.5},
        offset    = {x = -220, y = 0},
        text      = "score_background.png",
        scale     = { x = 1, y = 1},
        alignment = { x = 1, y = 0 },
    })

    --You will now have this:
    --screenshot of the HUD so far
    --Parameters

    --The text field is used to provide the image name.

    --If a co-ordinate is positive, then it is a scale factor with 1 being the original image size, 2 being double the size, and so on. However, if a co-ordinate is negative, it is a percentage of the screen size. For example, x=-100 is 100% of the width.
    --Scale

    --Let’s make the progress bar for our score panel as an example of scale:

    local percent = tonumber(meta:get("score:score") or 0.2)

    player:hud_add({
        hud_elem_type = "image",
        position  = {x = 1, y = 0.5},
        offset    = {x = -215, y = 23},
        text      = "score_bar_empty.png",
        scale     = { x = 1, y = 1},
        alignment = { x = 1, y = 0 },
    })

    player:hud_add({
        hud_elem_type = "image",
        position  = {x = 1, y = 0.5},
        offset    = {x = -215, y = 23},
        text      = "score_bar_full.png",
        scale     = { x = percent, y = 1},
        alignment = { x = 1, y = 0 },
    })

    --We now have a HUD that looks like the one in the first post! There is one problem however, it won’t update when the stats change.
    --Changing an Element

    --You can use the ID returned by the hud_add method to update it or remove it later.

    local idx = player:hud_add({
         hud_elem_type = "text",
         text          = "Hello world!",
         -- parameters removed for brevity
    })

    player:hud_change(idx, "text", "New Text")
    player:hud_remove(idx)

    --The hud_change method takes the element ID, the property to change, and the new value. The above call changes the text property from “Hello World” to “New text”.

    --This means that doing the hud_change immediately after the hud_add is functionally equivalent to the following, in a rather inefficient way:

    local idx = player:hud_add({
         hud_elem_type = "text",
         text          = "New Text",
    })

    --Storing IDs
end)
score = {}
local saved_huds = {}

function score.update_hud(player)
    local player_name = player:get_player_name()

    -- Get the dig and place count from storage, or default to 0
    local meta        = player:get_meta()
    local digs_text   = "Digs: " .. meta:get_int("score:digs")
    local places_text = "Places: " .. meta:get_int("score:places")
    local percent     = tonumber(meta:get("score:score") or 0.2)

    local ids = saved_huds[player_name]
    if ids then
        player:hud_change(ids["places"], "text", places_text)
        player:hud_change(ids["digs"],   "text", digs_text)
        player:hud_change(ids["bar_foreground"],
                "scale", { x = percent, y = 1 })
    else
        ids = {}
        saved_huds[player_name] = ids

        -- create HUD elements and set ids into `ids`
    end
end

minetest.register_on_joinplayer(score.update_hud)

minetest.register_on_leaveplayer(function(player)
    saved_huds[player:get_player_name()] = nil
end)


